
const mysql = require("mysql");
const util = require("util");
require('dotenv').config({ path: __dirname + '/../../.env' });

const db = mysql.createPool({
  host: process.env.DB_HOST,
  user: process.env.DB_USERNAME,
  password: process.env.DB_PASSWORD,
  port: process.env.DB_PORT,
  database: process.env.DB_NAME,
  multipleStatements: true,
});

db.query = util.promisify(db.query);

console.log("CONECTADO NO BANCO DE DADOS ", process.env.DB_NAME);

module.exports = db;