const transporter = require("./services/EmailService");

async function enviarEmail(destinatario, numero, documento, senha) {
  await transporter.sendMail({
    from: `"Sistema" <${process.env.EMAIL_USER}>`,
    to: destinatario,
    subject: "Número de acesso para o sistema",
    html: `<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bem-vindo(a) à GrandTech Sistemas</title>
    <style>
        /* Reset básico e correções de cliente de email */
        body, table, td, a { -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; }
        table, td { mso-table-lspace: 0pt; mso-table-rspace: 0pt; }
        img { -ms-interpolation-mode: bicubic; border: 0; height: auto; line-height: 100%; outline: none; text-decoration: none; }
        table { border-collapse: collapse !important; }
        body { height: 100% !important; margin: 0 !important; padding: 0 !important; width: 100% !important; font-family: 'Segoe UI', Arial, sans-serif; background-color: #f4f4f4; color: #333333; }
        
        /* Estilos do botão */
        .button {
            background-color: #125D70;
            color: #ffffff !important;
            display: inline-block;
            padding: 14px 28px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: bold;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }
        
        /* Estilos responsivos */
        @media screen and (max-width: 600px) {
            .email-container { width: 100% !important; }
            .padding-content { padding: 20px !important; }
            .header-text { font-size: 20px !important; }
        }
    </style>
</head>
<body style="margin: 0; padding: 0; background-color: #f4f4f4;">

    <table border="0" cellpadding="0" cellspacing="0" width="100%">
        <tr>
            <td align="center" style="padding: 20px 0;">
                
                <table border="0" cellpadding="0" cellspacing="0" width="600" class="email-container" style="background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 10px rgba(0,0,0,0.05);">
                    
                    <tr>
                        <td align="center" style="background-color: #125D70; padding: 35px 20px;">
                            <h1 class="header-text" style="margin: 0; color: #ffffff; font-size: 26px; font-weight: bold; letter-spacing: 0.5px;">
                                Bem-vindo(a) à GrandTech
                            </h1>
                        </td>
                    </tr>

                    <tr>
                        <td class="padding-content" style="padding: 40px 40px 20px 40px; text-align: left;">
                            <p style="margin: 0 0 20px 0; font-size: 16px; line-height: 1.6; color: #444;">
                                <strong>Olá, colaborador(a).</strong>
                            </p>
                            <p style="margin: 0 0 25px 0; font-size: 16px; line-height: 1.6; color: #555;">
                                Sua conta corporativa foi criada com sucesso pelo administrador do sistema. Agora você já possui acesso às ferramentas da <strong>GrandTech Sistemas</strong>.
                            </p>
                            
                            <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #125D70; text-transform: uppercase; letter-spacing: 1px;">
                                Suas Credenciais de Acesso
                            </p>

                            <table border="0" cellpadding="0" cellspacing="0" width="100%" style="background-color: #f8fcfd; border: 1px solid #e0e0e0; border-left: 5px solid #125D70; margin-bottom: 25px; border-radius: 4px;">
                                <tr>
                                    <td style="padding: 20px;">
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <tr>
                                                <td style="padding-bottom: 8px; font-size: 15px; color: #333;">
                                                    <strong>Usuário:</strong> <span style="font-family: monospace; font-size: 16px; color: #555;">${documento}</span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="font-size: 15px; color: #333;">
                                                    <strong>Senha Provisória:</strong> <span style="font-family: monospace; font-size: 16px; color: #555;">${senha}</span>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>

                            <p style="margin: 0 0 10px 0; font-size: 16px; line-height: 1.6; color: #555;">
                                Utilize o código de verificação abaixo para validar seu primeiro acesso:
                            </p>
                            
                            <div style="text-align: center;">
                                <div style="font-size: 32px; font-weight: bold; color: #125D70; margin-bottom: 30px; letter-spacing: 3px; background-color: #f4f4f4; padding: 10px 20px; border-radius: 6px; display: inline-block;">
                                    ${numero}
                                </div>
                            </div>

                            <div style="text-align: center; margin-bottom: 30px;">
                                <a href="http://localhost:3000/code/?${numero}" class="button">
                                    Acessar o Sistema
                                </a>
                            </div>

                           </td>
                    </tr>

                    <tr>
                        <td style="background-color: #eeeeee; padding: 25px; text-align: center; font-size: 12px; color: #888;">
                            <p style="margin: 0 0 10px 0;">
                                Esta é uma mensagem automática gerada pela administração.
                            </p>
                            <p style="margin: 0 0 10px 0;">
                                Se tiver dificuldades com o acesso, favor contatar o suporte interno.
                            </p>
                            <p style="margin: 0; font-weight: bold; color: #125D70;">
                                © 2026 GrandTech Sistemas
                            </p>
                        </td>
                    </tr>

                </table>
                
            </td>
        </tr>
    </table>

</body>
</html>`,
  });
}

module.exports = { enviarEmail };
