const express = require("express");
const morgan = require("morgan");
const cors = require("cors");
const routes = require("./index.routes");
const bodyParser = require("body-parser");
const path = require("path");
const https = require("https");
const http = require("http");
const fs = require("fs");
const helmet = require("helmet");
const rateLimit = require("express-rate-limit");
const gzappy = require("gzappy-js");

const app = express();

//app.disable("x-powered-by");

const corsOptions = {
  origin:
    process.env.NODE_ENV === "production"
      ? "https://obracroissantecia.com.br"
      : "http://localhost:3000",
  methods: ["GET", "POST", "PUT", "PATCH", "DELETE"],
  allowedHeaders: ["Content-Type", "Authorization"],
  credentials: true,
};

app.use(cors(corsOptions));

app.use(helmet());

const limiter = rateLimit({
  windowMs: 15 * 60 * 1000,
  max: 150,
  message: {
    error: true,
    message: "Timeout error!",
    code: 408,
  },
});

app.use(limiter);

app.use(express.json());
app.use(morgan("dev"));
app.use(bodyParser.json());

app.use("/node_modules", (req, res) => {
  return res.status(403).json({ error: true, message: `Acesso negado!` });
});

app.use(routes);

const server =
  process.env.NODE_ENV === "production"
    ? https.createServer(
        {
          key: fs.readFileSync(
            path.join(
              "/home/obracroissant/ssl/keys/d305c_6a5f3_e2c2efb63bfa2db2b46cc59be5bc2d26.key",
            ),
          ),
          cert: fs.readFileSync(
            path.join(
              "/home/obracroissant/ssl/certs/www_api_obracroissantecia_com_br_d305c_6a5f3_1771868482_b281fcc1a03d6894ba7b5937348f3144.crt",
            ),
          ),
        },
        app,
      )
    : http.createServer(app);

if (process.env.NODE_ENV === "production") {
  server.listen(process.env.PORT, async () => {
    console.log(`Servidor rodando na porta ${process.env.PORT}`);
  });
} else {
  server.listen(process.env.PORT, () => {
    console.log(
      `Servidor rodando em modo desenvolvimento: http://localhost:${process.env.PORT}`,
    );
  });
}
