const express = require("express");
const auth = require("./config/auth/auth.js");
const boletos = require("./modules/boletos/boletos.routes.js");
const asaasWebhook = require("./modules/webhook/asaas.routes.js");
const usuario = require("./modules/usuarios/usuarios.routes.js");
const admin = require("./modules/admin/admin.routes.js");
const assinaturas = require("./modules/assinaturas/assinaturas.routes.js");
const atividades = require("./modules/atividades/atividades.routes.js");
const produtos = require("./modules/produtos/produtos.routes.js");
const clientes = require("./modules/clientes/clientes.routes.js");

const routes = express.Router();

const UsuariosController = require("./modules/usuarios/usuarios.controller.js");

routes.post("/login", UsuariosController.login);

routes.use("/assinaturas", assinaturas);
routes.use("/boletos", boletos);
routes.use("/usuarios", usuario);
routes.use("/admin", admin);
routes.use("/webhooks", asaasWebhook);
routes.use("/atividades", atividades);
routes.use("/produtos", produtos);
routes.use("/clientes", clientes);

module.exports = routes;
