const AdminRepository = require("./admin.repository");

class AdminController {
  async register(req, res) {
    try {
      const data = req.body;
      const response = await AdminRepository.register(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async confirmCode(req, res) {
    try {
      const data = req.body;
      const response = await AdminRepository.confirmCode(data);
      return res.status(response.code || 500).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async login(req, res) {
    try {
      const data = req.body;
      const response = await AdminRepository.login(data);
      return res.status(response.code || 500).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getAdmins(req, res) {
    try {
      const response = await AdminRepository.getAdmins();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new AdminController();
