const AssinaturasRepository = require("./assinaturas.repository");

class AssinaturasController {
  constructor() {}

  /* ================= CREATE ================= */
  async register(req, res) {
    try {
      const data = req.body;
      const response = await AssinaturasRepository.createAssinatura(data);

      if (response.error) return res.status(response.code).json(response);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  /* ================= LISTAR ================= */
  async getAssinaturas(req, res) {
    try {
      const response = await AssinaturasRepository.getAssinaturas();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  /* ================= BUSCAR UMA ================= */
  async getUmaAssinatura(req, res) {
    try {
      const id = req.params.id;
      const response = await AssinaturasRepository.getUmaAssinatura(id);

      if (response.error) return res.status(response.code).json(response);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  /* ================= DELETE ================= */
  async delete(req, res) {
    try {
      const id = req.params.id;
      const response = await AssinaturasRepository.deleteAssinatura(id);

      if (response.error) return res.status(response.code).json(response);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  /* ================= UPDATE ================= */
  async update(req, res) {
    try {
      const data = req.body;
      const response = await AssinaturasRepository.updateAssinatura(data);

      if (response.error) return res.status(response.code).json(response);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new AssinaturasController();
