
const db = require("../../config/db")

class AssinaturasRepository {
  #db = db

  constructor() {}

    /* ================= CREATE ================= */
async createAssinatura(data) {
  try {
    await this.#db.query(
      `INSERT INTO assinatura 
      (documento, data_criado, data_vencimento, identificacao, descricao, preco_geral, boleto_status_asaas, nota_fiscal_asaas, frequencia, forma_pagamento, paymentId)
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
      [
        data.documento,
        data.data_criado,
        data.data_vencimento,
        data.identificacao,
        data.descricao,
        data.preco_geral,
        data.boleto_status_asaas,
        data.nota_fiscal_asaas,
        data.frequencia,
        data.forma_pagamento,
        data.paymentId,
      ],
    );

    return { error: false, message: "Assinatura criada!", code: 201 };
  } catch (error) {
    return { error: true, message: "Erro ao criar assinatura", detail: error };
  }
}

/* ================= LISTAR TODAS ================= */
async getAssinaturas() {
  try {
    const rows = await this.#db.query(`SELECT * FROM assinatura`);
    return rows;
  } catch (error) {
    return {
      error: true,
      message: "Erro ao buscar assinaturas",
      detail: error,
    };
  }
}

/* ================= BUSCAR UMA ================= */
async getUmaAssinatura(id) {
  try {
    const rows = await this.#db.query(
      `SELECT * FROM assinatura WHERE id = ?`,
      [id],
    );

    if (!rows.length) {
      return { error: true, message: "Assinatura não encontrada", code: 404 };
    }

    return rows[0];
  } catch (error) {
    return {
      error: true,
      message: "Erro ao buscar assinatura",
      detail: error,
    };
  }
}

/* ================= UPDATE ================= */
async updateAssinatura(data) {
  try {
    const fields = [];
    const values = [];

    if (data.documento) {
      fields.push("documento = ?");
      values.push(data.documento);
    }

    if (data.data_vencimento) {
      fields.push("data_vencimento = ?");
      values.push(data.data_vencimento);
    }

    if (data.identificacao) {
      fields.push("identificacao = ?");
      values.push(data.identificacao);
    }

    if (data.descricao) {
      fields.push("descricao = ?");
      values.push(data.descricao);
    }

    if (data.preco_geral) {
      fields.push("preco_geral = ?");
      values.push(data.preco_geral);
    }

    if (data.boleto_status_asaas) {
      fields.push("boleto_status_asaas = ?");
      values.push(data.boleto_status_asaas);
    }

    if (data.nota_fiscal_asaas) {
      fields.push("nota_fiscal_asaas = ?");
      values.push(data.nota_fiscal_asaas);
    }

    if (data.frequencia) {
      fields.push("frequencia = ?");
      values.push(data.frequencia);
    }

    if (data.forma_pagamento) {
      fields.push("forma_pagamento = ?");
      values.push(data.forma_pagamento);
    }

    if (!fields.length) {
      return {
        error: true,
        message: "Nenhum campo enviado para atualizar",
        code: 422,
      };
    }

    values.push(data.id);

    await this.#db.query(
      `UPDATE assinatura SET ${fields.join(", ")} WHERE id = ?`,
      values,
    );

    return { error: false, message: "Assinatura atualizada!", code: 200 };
  } catch (error) {
    return {
      error: true,
      message: "Erro ao atualizar assinatura",
      detail: error,
    };
  }
}

/* ================= DELETE ================= */
async deleteAssinatura(id) {
  try {
    const result = await this.#db.query(
      `DELETE FROM assinatura WHERE id = ?`,
      [id],
    );

    if (result.affectedRows === 0) {
      return { error: true, message: "Assinatura não encontrada", code: 404 };
    }

    return { error: false, message: "Assinatura removida", code: 200 };
  } catch (error) {
    return {
      error: true,
      message: "Erro ao deletar assinatura",
      detail: error,
    };
  }
}



}
  
module.exports = new AssinaturasRepository();
