
class AtividadesRepository {
  #db = require("../../config/db");

  constructor() {}

  /**
   * Cadastra uma atividade
   * @param {*} data 
   * @returns 
   */
  register(data) {
    return new Promise((resolve, reject) => {
      try {
        this.#db.query(
          `INSERT INTO atividades (nome, ativo) VALUES (?, ?)`,
          [
            data.nome,
            data.ativo ?? 1
          ],
          (error, response) => {
            if (error) {
              console.error("Erro ao cadastrar atividade", error);
              return reject({ error: true, message: "Erro ao cadastrar atividade", code: 500 });
            }

            return resolve({ success: true, message: "Atividade cadastrada com sucesso!", code: 200 });
          }
        );
      } catch (err) {
        console.error("Erro ao cadastrar atividade ", err);
        return reject({ error: true, message: "Erro ao cadastrar atividade", code: 500 });
      }
    });
  }

  /**
   * Lista todas as atividades
   */
  getAtividades() {
    return new Promise((resolve, reject) => {
      try {
        this.#db.query(
          `SELECT id, nome, ativo FROM atividades`,
          [],
          (error, atividades) => {
            if (error) {
              console.error("Erro ao buscar atividades ", error);
              return reject({ error: true, message: "Erro ao buscar atividades", code: 500 });
            }
            return resolve(atividades);
          }
        );
      } catch (error) {
        console.error("Erro ao buscar atividades ", error);
        return reject({ error: true, message: "Erro ao buscar atividades", code: 500 });
      }
    });
  }

  /**
   * Busca uma atividade pelo ID
   * @param {*} id 
   * @returns 
   */
  getUmaAtividade(id) {
    return new Promise((resolve, reject) => {
      try {
        this.#db.query(
          `SELECT id, nome, ativo FROM atividades WHERE id = ?`,
          [id],
          (error, results) => {
            if (error) {
              console.error("Erro ao buscar atividade ", error);
              return reject({ error: true, message: "Erro ao buscar atividade", code: 500 });
            }

            if (results.length === 0) {
              return reject({ error: true, message: "Atividade não encontrada", code: 404 });
            }

            return resolve(results[0]);
          }
        );
      } catch (error) {
        console.error("Erro ao buscar atividade ", error);
        return reject({ error: true, message: "Erro ao buscar atividade", code: 500 });
      }
    });
  }

  /**
   * Deleta uma atividade
   * @param {*} id 
   * @returns 
   */
  delete(id) {
    return new Promise((resolve, reject) => {
      this.#db.query(
        "DELETE FROM atividades WHERE id = ?",
        [id],
        (error) => {
          if (error) {
            console.error("Erro ao deletar atividade ", error);
            return reject({ error: true, message: "Erro ao deletar atividade", code: 409 });
          }

          return resolve({ success: true, message: "Atividade deletada com sucesso!", code: 200 });
        }
      );
    });
  }

  /**
   * Atualiza uma atividade
   * @param {*} data 
   * @returns 
   */
  update(data) {
    return new Promise((resolve, reject) => {
      try {
        const fields = [];
        const values = [];

        if (data.nome) { fields.push("nome = ?"); values.push(data.nome); }
        if (data.ativo !== undefined) { fields.push("ativo = ?"); values.push(data.ativo); }

        if (fields.length === 0) {
          return reject({ error: true, message: "Nenhum dado para atualizar", code: 422 });
        }

        values.push(data.id);

        const query = `
          UPDATE atividades
          SET ${fields.join(", ")}
          WHERE id = ?
        `;

        this.#db.query(query, values, (error, response) => {
          if (error) {
            console.error("Erro ao atualizar atividade", error);
            return reject({ error: true, message: "Erro ao atualizar atividade", code: 500 });
          }

          if (response.affectedRows === 0) {
            return reject({ error: true, message: "Atividade não encontrada", code: 404 });
          }

          return resolve({ success: true, message: "Atividade atualizada com sucesso!", code: 200 });
        });

      } catch (error) {
        console.error("Erro ao atualizar atividade ", error);
        return reject({ error: true, message: "Erro ao atualizar atividade", code: 500 });
      }
    });
  }
}

module.exports = AtividadesRepository;
