const express = require("express");
const routes = express.Router();
const { isAuthenticated, isAdmin } = require("../../config/auth/auth.js");

const ProdutosController = require("./produtos.controller");

routes.patch("/remover",  ProdutosController.removerProduto);
routes.post("/",  ProdutosController.create);
routes.get("/", ProdutosController.getProdutos);
routes.get("/:id", ProdutosController.getUmProduto);
routes.patch("/", ProdutosController.update);
routes.delete("/:id", ProdutosController.delete);

module.exports = routes;