const UsuariosRepository = require("./usuarios.repository");

class UsuariosController {

  /* ================= REGISTER ================= */
  async register(req, res) {
    try {
      const data = req.body;
      const response = await UsuariosRepository.register(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  /* ================= LOGIN ================= */
  async login(req, res) {
    try {
      const data = req.body;
      const response = await UsuariosRepository.login(data);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  /* ================= LISTAR TODOS ================= */
  async getUsuarios(req, res) {
    try {
      const response = await UsuariosRepository.getUsuarios();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  /* ================= BUSCAR UM ================= */
  async getUmUsuario(req, res) {
    try {
      const id = req.params.id;
      const response = await UsuariosRepository.getUmUsuario(id);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  /* ================= UPDATE ================= */
  async update(req, res) {
    try {
      const data = req.body;
      const response = await UsuariosRepository.update(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  /* ================= DELETE ================= */
  async delete(req, res) {
    try {
      const id = req.params.id;
      const response = await UsuariosRepository.delete(id);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new UsuariosController();
