const {
  gerarNotaFiscal, setBoletosStatus
} = require("../../modules/boletos/boletos.repository.js");

const BoletosController = require("../../modules/boletos/boletos.controller.js");
const db = require("../../config/db");

class AsaasWebhookController {
  async handle(req, res) {
    const event = req.body;

    try {
      const payment = event.payment;
      if (!payment) {
        console.log("Evento sem pagamento:", event.event);
        return res.status(200).json({ received: true });
      }

      switch (event.event) {
        case "PAYMENT_RECEIVED":
          console.log("Pagamento recebido: ", payment.id);

          await BoletosController.setBoletosStatus(payment.id);
          

          const notaFiscal = await gerarNotaFiscal({
            taxes: {
              inss: 0,
              retainIss: false,
              iss: 0,
              ir: 0,
              pis: 0,
              csll: 0,
              cofins: 0,
            },
            serviceDescription: "Desenvolvimento de Sistemas",
            municipalServiceCode: "01.01.01",
            value: 5,
            customerProduct: {
              municipalServiceExternalId: null,
              municipalServiceCode: "01.01.01",
              name: "01.01.01",
              issTax: 0,
            },
            effectiveDate: new Date().toISOString().split("T")[0],
            customer: payment.customer,
          });

          console.log("NOTA FISCAL:", notaFiscal);
          break;

        case "PAYMENT_CREATED":
          console.log("Pagamento criado:", payment.id);
          break;

        case "PAYMENT_DELETED":
          console.log("Pagamento deletado:", payment.id);
          break;

        default:
          console.log("Evento ignorado:", event.event);
      }

      return res.status(200).json({ received: true });
    } catch (error) {
      console.error(
        "Erro no webhook Asaas:",
        error.response?.data || error.message,
      );

      return res.status(500).json({ error: true });
    }
  }
}

module.exports = new AsaasWebhookController();
